#ifndef CONSOLE_H_
#define CONSOLE_H_

#include <stdarg.h>

#define GLYPH_WIDTH 6
#define GLYPH_HEIGHT 9

#define LINE_HEIGHT 13
#define CONSOLE_LINES 6
#define INPUT_COMMAND_LENGTH 500
#define NUM_SAVED_COMMANDS 10
#define CONSOLE_HISTORY_LINES 30

void print_to_console(char *msg, va_list);
void save_for_frame_break(char *msg, va_list args);
void print_to_bottom(char *text);
void draw_buttons(SDL_Surface *screen);

extern int current_command;
extern int history_pos;

void draw_glyph(char glyph, SDL_Surface *screen, int x, int y);
void draw_console(SDL_Surface *screen);
void update_command_list();
void update_console_history(char *new_item);
void clear_input_string();

#endif /*CONSOLE_H_*/
